define(['angular', 'app', 'moment', 'lodash'], function (angular, app, moment) {
	'use strict';

	app.controller('TrackersEntryController', function (formatter,
														$scope,
														$state,
														$stateParams,
														$filter,
														$parse,
														TrackersConstants,
														TrackersService,
														TrackersRemindersService,
														modalService,
														focusService) {

		var service = TrackersService.instance($stateParams.section);
		$scope.section = $stateParams.section;
		angular.extend($scope, TrackersConstants[$stateParams.section].entry);
		
		$scope.notificationDetails = {
			notificationStatus: ''
		};


        $scope.openMoodModal = function () {
            var modalContent = {
                closeButtonText: 'Cancel',
                actionButtonText: 'OK',
                bodyContentUrl: 'src/modules/health-mood/pages/entry/partials/mood-modal_template.html',
                headerText: 'Select Mood',
                data: {value: $scope.details.valueQuantity.value || 5}
            };

            modalService.showModal({}, modalContent).then(function () {
                $scope.details.valueQuantity.value = modalContent.data.value;
                $scope.form.$setDirty();
            }).finally(function () {
                focusService.focusElement('button[ng-click="openMoodModal()"]');

            });
        };

        TrackersRemindersService.init($stateParams.section);
		TrackersRemindersService.getReminder(TrackersConstants[$stateParams.section].name).then(function (response) {
			$scope.notificationDetails = angular.copy(response);
		});

		$scope.entryForm = {
			service: service,
			callbacks: {
				common: function () {
					$state.go($state.current.data.backState, $stateParams);
				}
			},
			allowedActions: {
				save: true,
				delete: !!$stateParams.id,
				cancel: true
			}
		};

		$scope.errorHandling = {
			'uniqueDateTime': {
				message: 'An entry has already been saved with the same date and time. Please change your date and/or time and save again.',
				priority: 1
			}
		};

		if ($stateParams.section === 'fitness-goals') {
			var endDate = moment().add(7,'day').format('L');
			var startDate = moment().format('L');



		//	$scope.details.extension[5].valueString = formatter.getFormattedFrontendDate(endDate);
		//	$scope.details.extension[4].valueString = formatter.getFormattedFrontendDate(startDate);
		}

		if ($stateParams.section === 'bp-pulse') {
			$scope.errorHandling['validBP'] = {
				message: 'The Systolic (mmHg) value must be greater than the Diastolic (mmHg) value. Please check the values and re-enter.',
				priority: 1
			}

			$scope.$watch("[details.component[0].valueQuantity.value, details.component[1].valueQuantity.value]", function(curVal, prevVal){
				if(!angular.equals(curVal, prevVal) && $scope.trackerForm) {
					var systolic = curVal[0],
					    diastolic = curVal[1],
					    valid = !systolic || !diastolic || parseInt(systolic) > parseInt(diastolic);

					$scope.trackerForm.specialErrors.$setValidity("validBP", valid);
				}
			}, true);
		}

		if ($stateParams.section === 'fitness-goals') {

			$scope.$watch('[details.extension[4].valueString]', function() {

				if ($scope.details.extensions) {
					delete $scope.details.extensions;
					delete $scope.details.activeFlag;
					delete $scope.details.startDate;
					delete $scope.details.endDate;
					delete $scope.details.target;
					delete $scope.details.progress;
				}

				$scope.details.extension[3].valueString = 'true';
				var endDate =formatter.getFormattedFrontendDate(formatter.getDateTimeMinusDelta($scope.details.extension[5].valueString, {days:0}, "front"));
				$scope.details.extension[5].valueString = formatter.getFormattedFrontendDate(formatter.getDateTimeMinusDelta(endDate, {days: 7}, 'front'));


			}, true);


		}

		if ($stateParams.section === "cholesterol") {
			$scope.hidden = true;
			$scope.errorHandling = {
				'Invalid-Date': {
					message: "An entry has already been saved with the same date. Please change your date and save again.",
					priority: 1
				},
				'Lab-Result-Required': {
					message: "Provide at least one Lab Result value to save your entry.",
					priority: 1
				}
			};
		};



		var minDate = moment().subtract(6,'year').format('L');
		$scope.allowedDateRange = { min: minDate };

		$scope.sectionTitle = $filter('filter')($state.current.data.paramSections, { paramValue: $stateParams.section }, true)[0].sectionName;




		$scope.details = $stateParams.id ? angular.copy(service.localGetById($stateParams.id)) : service.createEmpty();


		if (!$scope.details) {
        	$stateParams.id = null;
            $state.go($state.current.name, $stateParams, { reload: true });
       	}


	});
});